Imports System.Windows.Forms

<ComClass(Api.ClassId, Api.InterfaceId, Api.EventsId)> _
Public Class Api

#Region "COM GUIDs"
    ' These  GUIDs provide the COM identity for this class 
    ' and its COM interfaces. If you change them, existing 
    ' clients will no longer be able to access the class.
    Public Const ClassId As String = "6A7FD308-6FF6-4FE3-A536-813C1400C439"
    Public Const InterfaceId As String = "05073E2E-2EDC-49B3-BC50-D075FCC33012"
    Public Const EventsId As String = "9CA06C4C-D86C-47F7-B8D6-8D280129DF1A"
#End Region

    ' A creatable COM class must have a Public Sub New() 
    ' with no parameters, otherwise, the class will not be 
    ' registered in the COM registry and cannot be created 
    ' via CreateObject.
    Public Sub New()
        MyBase.New()
    End Sub

    Private myTestWindow As TestForm


    'Versionsinformationen per Windows-API abfragen
    '(Achtung: Strukturparameter als Referenz bergeben)
    '(Hinweis: As Any ist als Deklaration nicht mehr unzulssig, daher wird hier die Funktion mehrfach deklariert)
    Public Declare Function GetVersion Lib "kernel32" Alias "GetVersionExA" _
      (ByRef lpVersionInformation As OSVERSIONINFO) As Short
    Public Declare Function GetVersionEx Lib "kernel32" Alias "GetVersionExA" _
      (ByRef lpVersionInformationEx As OSVERSIONINFOEX) As Short

    Public Structure OSVERSIONINFO
        'Struktur unter allen Windows-Versionen
        'normale Strukturelemente
        Dim dwOSVersionInfoSize As Integer
        Dim dwOSMajorVersion As Integer
        Dim dwOSMinorVersion As Integer
        Dim dwBuildNumber As Integer
        Dim dwPlatformId As Integer
        'festest Strukturelement erfordert gesonderte Einrichtung fr Unmanaged Code,
        'da feste Zeichenketten nicht mehr untersttzt werden
        '(feste Zeichenkette mit 128 Zeichen)
        <VBFixedString(128), System.Runtime.InteropServices.MarshalAs( _
        System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=128)> _
        Dim szCSDVersion As String
    End Structure

    Public Structure OSVERSIONINFOEX
        'Struktur unter allen Windows-Versionen
        'normale Strukturelemente
        Dim dwOSVersionInfoSize As Integer
        Dim dwOSMajorVersion As Integer
        Dim dwOSMinorVersion As Integer
        Dim BuildNumber As Integer
        Dim PlatformId As Integer
        'festest Strukturelement erfordert gesonderte Einrichtung fr Unmanaged Code,
        'da feste Zeichenketten nicht mehr untersttzt werden
        '(feste Zeichenkette mit 128 Zeichen)
        <VBFixedString(128), System.Runtime.InteropServices.MarshalAs( _
        System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst:=128)> _
        Dim szCSDVersion As String
        'Strukturerweiterung fr aktuelle Systemversionen
        Dim wServicePackMajor As Short
        Dim wServicePackMinor As Short
        Dim wSuiteMask As Short
        Dim wProductType As Byte
        Dim wReserved As Byte
    End Structure

    Public Const VER_PLATFORM_WIN32_NT As Integer = 2
    Public Const VER_PLATFORM_WIN32_WINDOWS As Integer = 1
    Public Const VER_PLATFORM_WIN32s As Integer = 0
    Public Const VER_NT_WORKSTATION As Integer = 1
    Public Const VER_NT_DOMAIN_CONTROLLER As Integer = 2
    Public Const VER_NT_SERVER As Integer = 3
    Public Const VER_SUITE_SMALLBUSINESS As Integer = 1
    Public Const VER_SUITE_ENTERPRISE As Integer = 2
    Public Const VER_SUITE_BACKOFFICE As Integer = 4
    Public Const VER_SUITE_COMMUNICATIONS As Integer = 8
    Public Const VER_SUITE_TERMINAL As Integer = 10
    Public Const VER_SUITE_SMALLBUSINESS_RESTRICTED As Integer = 20
    Public Const VER_SUITE_EMBEDDEDNT As Integer = 40
    Public Const VER_SUITE_DATACENTER As Integer = 80
    Public Const VER_SUITE_SINGLEUSERTS As Integer = 100
    Public Const VER_SUITE_PERSONAL As Integer = 200
    Public Const VER_SUITE_BLADE As Integer = 400

    'Speicherinformationen abfragen
    'Speicherinformationen
    Public Declare Sub GlobalMemoryStatus Lib "kernel32" (ByRef lpBuffer As MEMORYSTATUS)

    Public Structure MEMORYSTATUS
        Dim dwLength As Integer
        Dim dwMemoryLoad As Integer
        Dim dwTotalPhys As Integer
        Dim dwAvailPhys As Integer
        Dim dwTotalPageFile As Integer
        Dim dwAvailPageFile As Integer
        Dim dwTotalVirtual As Integer
        Dim dwAvailVirtual As Integer
    End Structure

    'Windows- und Windows-Systemverzeichnis ermitteln
    Public Declare Function GetSystemDirectory Lib "kernel32" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
    Public Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

    'Benutzer-/Rechnerinformationen per API
    Public Declare Function GetUserName Lib "advapi32.dll" Alias "GetUserNameA" (ByVal lpBuffer As String, ByRef nSize As Integer) As Integer
    Public Declare Function GetUserNameEx Lib "secur32.dll" Alias "GetUserNameExA" (ByVal uFormat As uFormatType, ByVal lpBuffer As String, ByRef nSize As Integer) As Integer
    Public Declare Function GetComputerName Lib "kernel32" Alias "GetComputerNameA" (ByVal lpBuffer As String, ByRef nSize As Integer) As Integer
    Public Declare Function GetComputerNameEx Lib "secur32.dll" Alias "GetComputerNameExA" (ByVal uFormat As uFormatType, ByVal lpBuffer As String, ByRef nSize As Integer) As Integer

    Public Enum uFormatType
        'Formattypen von Benutzernamen in Verbindung
        'mit ADS
        NameUnknown = 0
        NameFullyQualifiedDN = 1
        NameSamCompatible = 2
        NameDisplay = 3
        NameUniqueId = 6
        NameCanonical = 7
        NameUserPrincipal = 8
        NameCanonicalEx = 9
        NameServicePrincipal = 10
        NameDnsDomain = 12
    End Enum

    Public Enum cFormatType
        'Formattypen von Computernamen in Verbindung
        'mit ADS (hier fortlaufende Enumeration 0... )
        ComputerNameNetBios
        ComputerNameDnsHostname
        ComputerNameDnsDomain
        ComputerNameDnsFullyQualified
        ComputerNamePhysicalNetBios
        ComputerNamePhysicalDnsHostname
        ComputerNamePhysicalDnsDomain
        ComputerNamePhysicalDnsFullyQualified
    End Enum

    'Laufwerke analysieren per API
    'Laufwerksgre
    Public Declare Function GetDiskFreeSpace Lib "kernel32" Alias "GetDiskFreeSpaceA" (ByVal lpRootPathName As String, ByRef SectorsPerCluster As Integer, ByRef lpBytesPerSector As Integer, ByRef lpNumberOfFreeClusters As Integer, ByRef lpTotalNumberOfClusters As Integer) As Integer

    'Laufwerksinfos ermitteln
    Public Declare Function GetVolumeInformation Lib "kernel32" Alias "GetVolumeInformationA" (ByVal lpRootPathName As String, ByVal lpVolumeNameBuffer As String, ByVal nVolumeNameSize As Integer, ByRef lpVolumeSerialNumber As Integer, ByRef lpMaximumComponentLength As Integer, ByRef lpFileSystemFlags As Integer, ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Integer) As Integer

    Public Const FILE_CASE_PRESERVED_NAMES As Short = &H2S
    Public Const FILE_CASE_SENSITIVE_SEARCH As Short = &H1S
    Public Const FILE_UNICODE_ON_DISK As Short = &H4S
    Public Const FILE_VOLUME_IS_COMPRESSED As Short = &H8000S
    Public Const FILE_PERSISTENT_ACLS As Short = &H8S
    Public Const FILE_FILE_COMPRESSION As Short = &H10S
    Public Const FS_CASE_IS_PRESERVED As Short = FILE_CASE_PRESERVED_NAMES
    Public Const FS_CASE_SENSITIVE As Short = FILE_CASE_SENSITIVE_SEARCH
    Public Const FS_UNICODE_STORED_ON_DISK As Short = FILE_UNICODE_ON_DISK
    Public Const FS_VOLUME_IS_COMPRESSED As Short = FILE_VOLUME_IS_COMPRESSED
    Public Const FS_PERSISTENT_ACLS As Short = FILE_PERSISTENT_ACLS
    Public Const FS_FILE_COMPRESSION As Short = FILE_FILE_COMPRESSION

    Public Function GetSysInfoString() As String
        Dim xInfo As OSVERSIONINFOEX = Nothing
        'Zeichenkette fr Systeminformationen
        Dim Msg As String = String.Empty
        'allgemeine Systeminformationen
        'Gre der Struktur in Strukturelement schreiben (148 Byte)
        Dim sInfo As OSVERSIONINFO = Nothing
        sInfo.dwOSVersionInfoSize = Len(sInfo)
        Try
            If GetVersion(sInfo) <> 0 Then
                'erweiterte Infos abrufen (grtenteils zu den Grundinfos identisch, allerdings
                'nicht fr ltere Windows-Versionen verfgbar)

                Dim erg As Short
                xInfo.dwOSVersionInfoSize = Len(xInfo)
                erg = GetVersionEx(xInfo)
                Select Case sInfo.dwPlatformId
                    Case VER_PLATFORM_WIN32_NT
                        'NT/2000/XP-System
                        Msg = Msg & "Plattformkennung: Windows NT [Win32]" & vbCrLf
                        'Produktkennung
                    Case VER_PLATFORM_WIN32_WINDOWS
                        'Consumer-Windows
                        Msg = Msg & "Plattformkennung: Windows 95 [Win32]" & vbCrLf
                    Case VER_PLATFORM_WIN32s
                        'dieses System wird nicht mehr von .NET untersttzt, 
                        'also auch nicht mehr aufgerufen
                        Msg = Msg & "Plattformkennung: Windows 3.1 [Win32s]" & vbCrLf
                End Select
                'Windows-System
                Select Case sInfo.dwOSMajorVersion
                    Case 3 'NT 3.51 (wird nicht von .NET untersttzt)
                        Msg = Msg & "Betriebssystem: Windows NT 3." & sInfo.dwOSMinorVersion
                    Case 4 '95/98/SE/ME/NT 4.0
                        Select Case sInfo.dwOSMinorVersion
                            Case 0
                                '95/NT 4.0
                                If sInfo.dwPlatformId = VER_PLATFORM_WIN32_NT Then
                                    Msg = Msg & "Betriebssystem: Windows NT (Version 4.0." & _
                                          sInfo.dwBuildNumber.ToString & ")" & ")"
                                Else
                                    If sInfo.szCSDVersion = "C" Then
                                        Msg = Msg & "Betriebssystem: Windows 95 OSR 2 (Version 4.0." & _
                                          (sInfo.dwBuildNumber And &HFFFF&).ToString & ")"
                                    Else
                                        Msg = Msg & "Betriebssystem: Windows 95 (Version 4.0." & _
                                          (sInfo.dwBuildNumber And &HFFFF&).ToString & ")"
                                    End If

                                End If
                            Case 10
                                If sInfo.szCSDVersion = "A" Then
                                    Msg = Msg & "Betriebssystem: Windows 98 SE (Version 4.10." & _
                                          (sInfo.dwBuildNumber And &HFFFF&).ToString & ")"
                                Else
                                    Msg = Msg & "Betriebssystem: Windows 98 (Version 4.10." & _
                                          (sInfo.dwBuildNumber And &HFFFF&).ToString & ")"
                                End If
                            Case 90
                                Msg = Msg & "Betriebssystem: Windows ME (Version 4.90." & _
                                          (sInfo.dwBuildNumber And &HFFFF&).ToString & ")"
                        End Select
                    Case 5 '2000/XP/.NET Server
                        If sInfo.dwBuildNumber = 2195 Then
                            'Service-Packinfo mit anhngen (sInfo.szCSDVersion)
                            Msg = Msg & "Betriebssystem: Windows 2000 (Version: 5.0." & _
                                  sInfo.dwBuildNumber.ToString & ") " & vbCrLf
                            Msg = Msg & "Zusatzinformation: " & sInfo.szCSDVersion
                        ElseIf sInfo.dwBuildNumber = 2600 Then
                            Msg = Msg & "Windows XP (Version 5.1." & _
                                  sInfo.dwBuildNumber.ToString & ") " & vbCrLf
                            Msg = Msg & "Zusatzinformation: " & sInfo.szCSDVersion
                        End If
                        'erweiterte Infos abrufen
                        If erg <> 0 Then
                            'Versionsnummer des zuletzt eingerichteten Service-Packs
                            Msg = Msg & vbCrLf & "Service-Pack-Version: " & xInfo.wServicePackMajor.ToString & _
                                    "." & xInfo.wServicePackMinor.ToString & vbCrLf
                            'erweiterte Systeminfos fr NT/2000/XP-Systeme anzeigen
                            '(Detaillierte NT-Systemabfrage) 
                            Select Case xInfo.wProductType
                                Case VER_NT_WORKSTATION
                                    Msg = Msg & "Produkttyp: Workstation (XP Home/professional, 2000 oder NT 4.0)" & vbCrLf
                                Case VER_NT_DOMAIN_CONTROLLER
                                    Msg = Msg & "Produkttyp: Domnen-Controller" & vbCrLf
                                Case VER_NT_SERVER
                                    Msg = Msg & "Produkttyp: Server" & vbCrLf
                            End Select
                            If xInfo.wSuiteMask And VER_SUITE_BACKOFFICE Then
                                Msg = Msg & "Microsoft Backoffice-Komponenten: installiert" & vbCrLf
                            Else
                                Msg = Msg & "Microsoft Backoffice-Komponenten: nicht installiert" & vbCrLf
                            End If
                            If xInfo.wSuiteMask And VER_SUITE_DATACENTER Then
                                Msg = Msg & "Windows 2000 Datacenter Server: installiert" & vbCrLf
                            Else
                                Msg = Msg & "Windows 2000 Datacenter Server: nicht installiert" & vbCrLf
                            End If
                            If xInfo.wSuiteMask And VER_SUITE_ENTERPRISE Then
                                Msg = Msg & "Windows 2000 Advanced/.NET Enterprise Server: installiert" & vbCrLf
                            Else
                                Msg = Msg & "Windows 2000 Advanced/.NET Enterprise Server: nicht installiert" & vbCrLf
                            End If
                            If xInfo.wSuiteMask And VER_SUITE_PERSONAL Then
                                Msg = Msg & "Windows XP Home: installiert" & vbCrLf
                            Else
                                Msg = Msg & "Windows XP Home: nicht installiert" & vbCrLf
                            End If
                            If xInfo.wSuiteMask And VER_SUITE_SMALLBUSINESS Then
                                Msg = Msg & "Microsoft Small Business Server: installiert" & vbCrLf
                            Else
                                Msg = Msg & "Microsoft Small Business Server: nicht installiert" & vbCrLf
                            End If
                            If xInfo.wSuiteMask And VER_SUITE_SMALLBUSINESS_RESTRICTED Then
                                Msg = Msg & "Microsoft Small Business Server (restricted): installiert" & vbCrLf
                            Else
                                Msg = Msg & "Microsoft Small Business Server (restricted): nicht installiert" & vbCrLf
                            End If
                            If xInfo.wSuiteMask And VER_SUITE_TERMINAL Then
                                Msg = Msg & "Terminaldienste: installiert" & vbCrLf
                            Else
                                Msg = Msg & "Terminaldienste: nicht installiert" & vbCrLf
                            End If
                        Else
                            Msg = Msg & vbCrLf
                        End If
                End Select
            End If
        Catch
            'Fehler
            Msg = "Die Systeminformationen konnten nicht ermittelt werden!"
        End Try
        'Speicherinformationen
        'via -> MemInfo
        Dim AvailVirtual As Integer
        Dim Virtual As Integer
        Dim AvailPageFile As Integer
        Dim PageFile As Integer
        Dim Avail As Integer
        Dim Physical As Integer
        Dim Used As Integer
        'Speicherinformationen abfragen
        MemInfo(Used, Physical, Avail, PageFile, AvailPageFile, Virtual, AvailVirtual)
        'und fr die Ausgabe aufbereiten
        Msg = Msg & "Physikalischer Speicher: " & Str(Physical) & " KByte" & vbCrLf
        Msg = Msg & "Freier physikalischer Speicher: " & Str(Avail) & " KByte" & vbCrLf
        Msg = Msg & "Belegter physikalischer Speicher: " & Str(Physical - Avail) & " KByte" & vbCrLf
        Msg = Msg & "Virtueller Speicher: " & Str(Virtual) & " KByte" & vbCrLf
        Msg = Msg & "Freier virtueller Speicher: " & Str(AvailVirtual) & " KByte" & vbCrLf
        Msg = Msg & "Belegter virtueller Speicher: " & Str(Virtual - AvailVirtual) & " KByte" & vbCrLf
        Msg = Msg & "Speichergre Auslagerungsdatei: " & Str(PageFile) & " KByte" & vbCrLf
        Msg = Msg & "davon frei: " & Str(AvailPageFile) & " KByte" & vbCrLf
        Msg = Msg & "davon belegt: " & Str(PageFile - AvailPageFile) & " KByte" & vbCrLf
        'Systemverzeichnis 
        'via -> SysInfo
        Msg = Msg & "Windows-Verzeichnis: " & WinDir() & vbCrLf
        Msg = Msg & "Windows-Systemverzeichnis: " & SysDir() & vbCrLf
        'Informationen im Textfeld anzeigen
        Return Msg
    End Function

    Public Function GetUserInfoString() As String
        'Benutzerinformationen anzeigen
        Dim Msg As String
        'Identittsinformationen des angemeldeten Benutzers
        Dim sObj As System.Security.Principal.WindowsIdentity
        'Prinzipal (Rechner/Benutzername)
        Dim Principal As String = sObj.GetCurrent.Name
        Dim pArray As System.Array
        pArray = Principal.Split("\")
        Msg = "Name: " & Principal & vbCrLf & _
          "Rechnername (.NET): " & pArray(0) & vbCrLf & _
          "Benutzername (.NET): " & pArray(1) & vbCrLf & _
          "Authentifizierungstyp: " & sObj.GetCurrent.AuthenticationType & vbCrLf & _
          "System: " & B2S(sObj.GetCurrent.IsSystem) & vbCrLf & _
          "Gast: " & B2S(sObj.GetCurrent.IsGuest) & vbCrLf & _
          "authentifiziert: " & B2S(sObj.GetCurrent.IsAuthenticated) & vbCrLf & _
          "anonym: " & B2S(sObj.GetCurrent.IsAnonymous) & vbCrLf & _
          "Token: " & sObj.GetCurrent.Token.ToString & " [IntPtr]" & vbCrLf & _
          "Benutzername (API): " & GetUser() & vbCrLf & _
          "- Unknown: " & GetUserEx(uFormatType.NameUnknown) & vbCrLf & _
          "- FullyQualifiedDN: " & GetUserEx(uFormatType.NameFullyQualifiedDN) & vbCrLf & _
          "- SamCompatible: " & GetUserEx(uFormatType.NameSamCompatible) & vbCrLf & _
          "- Display: " & GetUserEx(uFormatType.NameDisplay) & vbCrLf & _
          "- UniqueId: " & GetUserEx(uFormatType.NameUniqueId) & vbCrLf & _
          "- Canonical: " & GetUserEx(uFormatType.NameCanonical) & vbCrLf & _
          "- UserPrincipal: " & GetUserEx(uFormatType.NameUserPrincipal) & vbCrLf & _
          "- CanonicalEx: " & GetUserEx(uFormatType.NameCanonicalEx) & vbCrLf & _
          "- ServicePrincipal: " & GetUserEx(uFormatType.NameServicePrincipal) & vbCrLf & _
          "- DnsDomain: " & GetUserEx(uFormatType.NameDnsDomain) & vbCrLf & _
          "Rechnername (API): " & GetComputer() & vbCrLf & _
          "- NetBios: " & GetComputerEx(cFormatType.ComputerNameNetBios) & vbCrLf & _
          "- DnsHostname: " & GetComputerEx(cFormatType.ComputerNameDnsHostname) & vbCrLf & _
          "- DnsDomain: " & GetComputerEx(cFormatType.ComputerNameDnsDomain) & vbCrLf & _
          "- DnsFullyQualified: " & GetComputerEx(cFormatType.ComputerNameDnsFullyQualified) & vbCrLf & _
          "- PhysicalNetBios: " & GetComputerEx(cFormatType.ComputerNamePhysicalNetBios) & vbCrLf & _
          "- PhysicalDnsHostname: " & GetComputerEx(cFormatType.ComputerNamePhysicalDnsHostname) & vbCrLf & _
          "- PhysicalDnsDomain: " & GetComputerEx(cFormatType.ComputerNamePhysicalDnsDomain) & vbCrLf & _
          "- PhysicalDnsFullyQualified: " & GetComputerEx(cFormatType.ComputerNamePhysicalDnsFullyQualified) & vbCrLf
        'Ergebnisse ausgeben
        Return (Msg.ToString)
    End Function

    Public Function GetDriveInfoString(ByVal sDrive As String) As String
        'Laufwerksinformationen anzeigen
        'via -> DiskFreeSpace und VolumeInformation
        Dim Msg As String
        Dim dFree As Integer
        Dim TotalClusters As Integer
        Dim FreeClusters As Integer
        Dim BytesPerSector As Integer
        Dim SectorsPerCluster As Integer
        Dim GesamtSpeicher As Long
        Dim Drive As String = String.Empty
        'Laufwerksspeicher fr angegebenes Laufwerk abfragen
        If Len(Drive) > 2 Then
            Drive = Mid(sDrive, 1, 2)
        ElseIf Len(Drive) = 1 Then
            Drive = Drive & ": "
        Else
            Drive = sDrive
        End If
        'benutzerdefinierte Funktion fr Speicherinfos zum aktuellen Laufwerk aufrufen
        dFree = DiskFreeSpace(Drive, GesamtSpeicher, SectorsPerCluster, BytesPerSector, FreeClusters, TotalClusters)
        'fr Textausgabe aufbereiten (Ausgabe in KByte und MByte)
        Msg = "Gesamtspeicher: " & GesamtSpeicher.ToString & " KByte [" & _
              (GesamtSpeicher \ 1024).ToString & " MByte]" & vbCrLf
        Msg = Msg & "davon frei: " & dFree.ToString & " Kbyte [" & _
              (dFree \ 1024).ToString & " MByte]" & vbCrLf
        'belegter Speicher errechenbar
        Msg = Msg & "davon belegt: " & Str(GesamtSpeicher - dFree) & " Kbyte [" & _
              ((GesamtSpeicher - dFree) \ 1024).ToString & "MByte]" & vbCrLf
        Msg = Msg & "Sektoren pro Cluster: " & Str(SectorsPerCluster) & vbCrLf
        Msg = Msg & "Bytes pro Sektor: " & Str(BytesPerSector) & vbCrLf
        Msg = Msg & "Freie Cluster-Anzahl: " & Str(FreeClusters) & vbCrLf
        Msg = Msg & "Gesamtzahl Cluster: " & Str(TotalClusters) & vbCrLf
        'Datentrgerinformationen abfragen

        'Dim AltVolName As String
        'Dim fLen As Integer
        Dim DosSerial As String
        Dim Flags As Integer
        Dim ComponentLength As Integer
        Dim VolSerial As Integer
        Dim fSystem As String = String.Empty
        Dim VolName As String = String.Empty
        'Dim Neu As String
        'Dim M As String
        'Laufwerk/Verzeichnis
        Msg = Msg & "Informationen fr Laufwerk: " & Drive & vbCrLf & vbCrLf
        REM    Msg = Msg & "Laufwerksverzeichnis (Control): " & DirCtl.Path & vbCrLf & vbCrLf
        'Datentrgerinformationen fr angewhltes Laufwerk abfragen 
        VolumeInformation(Drive + "\", VolName, fSystem, VolSerial, ComponentLength, Flags)
        'auswerten und in Ausgabezeichenkette bernehmen
        Msg = Msg & "Datentrgerbezeichnung: " & VolName & vbCrLf
        Msg = Msg & "Dateisystem: " & fSystem & vbCrLf
        Msg = Msg & "Seriennummer: " & VolSerial.ToString & vbCrLf
        'DOS-Seriennummer im Hexadezimalformat 
        '(entsprechend der blichen Anzeige der Eingabeaufforderung)
        DosSerial = Hex(HiWord(VolSerial)) & "-" & Hex(LoWord(VolSerial))
        Msg = Msg & "Seriennummer im DOS-Format: " & DosSerial & vbCrLf
        Msg = Msg & "maximale Dateinamenlnge: " & Str(ComponentLength) & vbCrLf & vbCrLf
        'Auswertung Flags-Parameter, die ber den Parameter Flags der Funktion
        'VolumeInformation zurckgeliefwert werden
        If Flags And FS_CASE_IS_PRESERVED Then
            Msg = Msg & "  - Gro-/Kleinschrift in Dateinamen wird gesichert" & vbCrLf
        End If
        If Flags And FS_CASE_SENSITIVE Then
            Msg = Msg & "  - Unterscheidung Gro-/Kleinschrift bei Dateinamen" & vbCrLf
        End If
        If Flags And FS_UNICODE_STORED_ON_DISK Then
            Msg = Msg & "  - Dateinamen in Unicode gesichert" & vbCrLf
        End If
        If Flags And FS_PERSISTENT_ACLS Then
            Msg = Msg & "  - Sicherheitszugriff auf Dateien wird untersttzt" & vbCrLf
        End If
        If Flags And FS_FILE_COMPRESSION Then
            Msg = Msg & "  - Dateisystem untersttzt Kompression auf Dateibasis" & vbCrLf
        End If
        If Flags And FS_VOLUME_IS_COMPRESSED Then
            Msg = Msg & "  - Laufwerk ist komprimiert"
        End If
        'Informationen ausgeben
        Return Msg
    End Function

    Public Function GetDirInfoString(ByVal sPath As String) As String
        'Verzeichnisinformationen anzeigen
        Dim Msg As String = String.Empty
        'Systemobjekt fr angewhltes Verzeichnis anlegen
        Dim DirObj As New System.IO.DirectoryInfo(sPath)
        'sicherheitshalber den Pfad auf Existenz berprfen
        If DirObj.Exists Then
            'voller Name des gewhlten Verzeichnisses
            Msg = Msg & "Name: " & DirObj.Name & vbCrLf & vbCrLf
            Msg = Msg & "voller Name: " & DirObj.FullName & vbCrLf & vbCrLf
            'Wurzelverzeichnis zum gewhlten Verzeichnis
            Msg = Msg & "Wurzelverzeichnis des angewhlten Pfades : " & DirObj.Root.Name & vbCrLf & vbCrLf
            'bergeordnetes Verzeichnis
            Msg = Msg & "bergeordneter Pfad: " & DirObj.Parent.Name & vbCrLf & vbCrLf
            Msg = Msg & "bergeordneter Pfad (voller Name): " & DirObj.Parent.FullName & vbCrLf & vbCrLf
            'Verzeichnisanlage
            Msg = Msg & "Datum/Uhrzeit der Verzeichnisanlage: " & DirObj.CreationTime & vbCrLf
            'letzter Verzeichniszugriff
            Msg = Msg & "letzter Verzeichniszugriff: " & DirObj.LastAccessTime & vbCrLf
            'letzte Verzeichnisnderung
            Msg = Msg & "letzte nderung: " & DirObj.LastWriteTime & vbCrLf
            'Erweiterung
            Msg = Msg & "Erweiterung: " & DirObj.Extension & vbCrLf & vbCrLf
            Msg = Msg & "feste Gre: " & B2S(DirObj.GetFileSystemInfos.IsFixedSize) & vbCrLf
            Msg = Msg & "Nur Lesen: " & B2S(DirObj.GetFileSystemInfos.IsReadOnly) & vbCrLf
            Msg = Msg & "synchronisiert: " & B2S(DirObj.GetFileSystemInfos.IsSynchronized) & vbCrLf & vbCrLf
        End If
        'Informationen ausgeben
        Return Msg
    End Function

    Public Function GetFileInfoString(ByVal sPath As String, ByVal sFile As String) As String
        'Dateiinformationen zur aktuell angewhlten Datei anzeigen
        Dim Msg As String = String.Empty
        Dim pFile As String = String.Empty
        If sFile = "" Then
            'Dateiwahl erforderlich
            MsgBox("Bitte whlen Sie zunchst eine Datei aus!", MsgBoxStyle.Exclamation, "Hinweis")
            Return String.Empty
        End If
        'gewhltes Verzeichnis mit Datei verketten
        'ggfs. doppelte Schrgstriche entfernen
        pFile = (sPath & "\" & sFile).Replace("\\", "\")
        'Systemobjekt fr angewhltes Verzeichnis anlegen
        Dim FileObj As New System.IO.FileInfo(pFile)
        'Existenz der Datei berprfen
        If FileObj.Exists Then
            Msg = "Dateiname: " & FileObj.Name & vbCrLf & vbCrLf
            Msg = Msg & "Dateiname samt Pfad: " & FileObj.FullName & vbCrLf & vbCrLf
            'Dateianlage 
            Msg = Msg & "Datum/Uhrzeit der Dateianlage: " & FileObj.CreationTime & vbCrLf
            'letzter Verzeichniszugriff
            Msg = Msg & "letzter Dateizugriff: " & FileObj.LastAccessTime & vbCrLf
            'letzte Verzeichnisnderung
            Msg = Msg & "letzte Dateinderung: " & FileObj.LastWriteTime & vbCrLf & vbCrLf
            'Erweiterung
            Msg = Msg & "Erweiterung: " & FileObj.Extension & vbCrLf & vbCrLf
            Msg = Msg & "Grsse: " & FileObj.Length & " Byte" & vbCrLf & vbCrLf
            Msg = Msg & "Verzeichnisname: " & FileObj.DirectoryName & vbCrLf & vbCrLf
        End If
        'Informationen ausgeben
        Return Msg
    End Function

    Private Function B2S(ByVal b As Boolean) As String
        'Boolean-Wert in Zeichentext fr lesbare 
        'Informationsausgabe(konvertieren)
        Select Case b
            Case True : Return "Ja (wahr)"
            Case False : Return "Nein (falsch)"
            Case Else : Return "Nein (falsch)"
        End Select
    End Function

    Public Function DiskFreeSpace(ByRef Drive As String, ByRef GesamtSpeicher As Long, ByRef SectorsPerCluster As Integer, ByRef BytesPerSector As Integer, ByRef FreeClusters As Integer, ByRef TotalClusters As Integer) As Integer
        Dim dummy As Integer
        'freie Laufwerkskapazitt in Byte ermitteln, Zusatzwerte optional abfragbar
        Drive = Mid(Drive, 1, 1) & ":\"
        dummy = GetDiskFreeSpace(Drive, SectorsPerCluster, BytesPerSector, FreeClusters, TotalClusters)
        'Speicherinformationen in KByte
        'Gesamtspeicher
        GesamtSpeicher = SectorsPerCluster * TotalClusters * (BytesPerSector / 1024)
        'freier Speicher
        Return (SectorsPerCluster * FreeClusters * (BytesPerSector / 1024)) 'in Byte
    End Function

    Public Sub VolumeInformation(ByRef Drive As String, ByRef VolName As String, ByRef fSystem As String, ByRef VolSerial As Integer, ByRef ComponentLength As Integer, ByRef Flags As Integer)
        Dim R As Integer
        Dim fLen As Integer
        Dim vLen As Integer
        'Laufwerksinformationen abfragen
        Drive = Mid(Drive, 1, 1) & ":\"
        'Puffer fr Ergebniszeichenketten aufbereiten
        VolName = New String(CChar(" "), 255)
        fSystem = New String(CChar(" "), 255)
        vLen = Len(VolName)
        fLen = Len(fSystem)
        R = GetVolumeInformation(Drive, VolName, vLen, VolSerial, ComponentLength, Flags, fSystem, fLen)
        'Ergebniszeichenkette auf korrekte Lnge krzen
        VolName = GetSystemString(VolName)
        fSystem = GetSystemString(fSystem)
    End Sub

    Public Sub MemInfo(ByRef Used As Integer, ByRef Physical As Integer, ByRef Avail As Integer, ByRef PageFile As Integer, ByRef AvailPageFile As Integer, ByRef Virtual As Integer, ByRef AvailVirtual As Integer)
        'Speicherinformationen (alle Werte in KByte umrechnen)
        Dim mInfo As MEMORYSTATUS
        mInfo.dwLength = Len(mInfo)
        GlobalMemoryStatus(mInfo)
        '% belegt
        Used = mInfo.dwMemoryLoad
        'physikal. Speicher in KByte
        Physical = mInfo.dwTotalPhys / 1024
        'freier physikal. Speicher in KByte
        Avail = mInfo.dwAvailPhys / 1024
        'Gre Auslagerungsdatei
        PageFile = mInfo.dwTotalPageFile / 1024
        'freie Auslagerungsdateigre
        AvailPageFile = mInfo.dwAvailPageFile / 1024
        'virtueller Speicher gesamt
        Virtual = mInfo.dwTotalVirtual / 1024
        'freier virtueller Speicher
        AvailVirtual = mInfo.dwAvailVirtual / 1024
    End Sub

    Public Function SysDir() As String
        'Windows-Systemverzeichnis ermitteln
        Dim vLen As Integer
        Dim Temp As String
        Temp = Space(255)
        vLen = GetSystemDirectory(Temp, Len(Temp))
        Temp = Mid(Temp, 1, vLen)
        'Werterckgabe
        Return Temp
    End Function

    Public Function WinDir() As String
        'Windows-Vverzeichnis ermitteln
        Dim vLen As Integer
        Dim Temp As String
        Temp = Space(255)
        vLen = GetWindowsDirectory(Temp, Len(Temp))
        Temp = Mid(Temp, 1, vLen)
        'Werterckgabe
        Return Temp
    End Function

    Public Function HiWord(ByRef DWord As Integer) As Short
        'hherwertiges Wort eines DWord (Typ: Integer) ermitteln
        If DWord And &H80000000 Then
            Return (DWord \ 65535) - 1
        Else
            Return DWord \ 65535
        End If
    End Function

    Public Function LoWord(ByRef DWord As Integer) As Short
        'niederwertiges Wort eines DWord (Typ: Integer) ermitteln
        If DWord And &H8000 Then
            Return &H8000S Or (DWord And &H7FFF)
        Else
            Return DWord And &HFFFF&
        End If
    End Function

    Public Function GetSystemString(ByVal Value As String) As String
        'per API ermittelte Systemzeichenkette auf korrekte 
        'Lnge krzen (einhergehend damit abschlieendes ASCIIZ-Zeichen lschen)
        Dim p As Integer
        p = InStr(Value, Chr(0))
        If p > 1 Then
            Return Value.Substring(0, p - 1)
        Else
            Return ""
        End If
    End Function

    Public Function GetUser() As String
        'aktuellen Benutzernamen abfragen
        Dim sUser As String
        Dim dummy As Integer
        'Pufferspeicher 255 Byte
        sUser = New String(CChar(" "), 255)
        'API-Funktionsaufruf
        dummy = GetUserName(sUser, Len(sUser))
        'Systemzeichenkette zurckliefern
        Return GetSystemString(sUser)
    End Function

    Public Function GetUserEx(ByVal e As uFormatType) As String
        'aktuellen Benutzernamen abfragen (erweiterte Abfrage mit Formatangabe)
        Dim sUser As String
        Dim dummy As Integer
        'Pufferspeicher 255 Byte
        sUser = New String(CChar(" "), 255)
        'API-Funktionsaufruf
        dummy = GetUserNameEx(e, sUser, Len(sUser))
        'Systemzeichenkette zurckliefern
        Return GetSystemString(sUser)
    End Function

    Public Function GetComputer() As String
        'Computernamen abfragen
        Dim sComputer As String
        Dim dummy As Integer
        'Pufferspeicher 255 Byte
        sComputer = New String(CChar(" "), 255)
        'API-Funktionsaufruf
        dummy = GetComputerName(sComputer, Len(sComputer))
        'Systemzeichenkette zurckliefern
        Return GetSystemString(sComputer)
    End Function

    Public Function GetComputerEx(ByVal e As cFormatType) As String
        'aktuellen Computernamen abfragen (erweiterte Abfrage mit Formatangabe)
        Dim sComputer As String
        Dim dummy As Integer
        'Pufferspeicher 255 Byte
        sComputer = New String(CChar(" "), 255)
        'API-Funktionsaufruf
        dummy = GetUserNameEx(e, sComputer, Len(sComputer))
        'Systemzeichenkette zurckliefern
        Return GetSystemString(sComputer)
    End Function

    Public Function OpenWindow(ByVal pHWND As Integer) As Boolean
        Dim myHandle As New IntPtr(pHWND)
        Dim myWindowWrapper As New WindowWrapper(myHandle)
        Try
            myTestWindow = New TestForm
            If pHWND > 0 Then
                myTestWindow.Show(myWindowWrapper)
            Else
                myTestWindow.Show()
            End If
            Return True
        Catch ex As Exception
            MessageBox.Show(ex.ToString)
            Return False
        End Try
    End Function

    Public Function CloseWindow() As Boolean
        Try
            myTestWindow.Close()
            Return True
        Catch ex As Exception
            Return False
        End Try
    End Function

    Public Sub SetWindowText(ByVal pText As String)
        If myTestWindow.Visible = True Then
            myTestWindow.SetText(pText)
        End If
    End Sub


    Protected Overrides Sub Finalize()
        MyBase.Finalize()
    End Sub
End Class


'This Helper class is necessary, to be able to 
'show the window modal when calling it from Omnis
Public Class WindowWrapper
    Implements System.Windows.Forms.IWin32Window
    Dim _hwnd As System.IntPtr
    Sub New(ByVal handle As IntPtr)
        _hwnd = handle
    End Sub

    Public ReadOnly Property Handle() As System.IntPtr Implements IWin32Window.Handle
        Get
            Return _hwnd
        End Get
    End Property
End Class